<?php

namespace WPDeveloper\BetterDocs\Admin\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use WPDeveloper\BetterDocs\Utils\Base;
use WPDeveloper\BetterDocs\Utils\Database;

/**
 * Customizer Defaults
 */
class Defaults extends Base {
	/**
	 * Summary of Database
	 * @var Database
	 */
	protected $database;

	public function __construct( Database $database ) {
		$this->database = $database;
	}

	/**
	 * Get all defaults option
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function defaults( $key = '' ) {
		$betterdocs_defaults = [
			'betterdocs_docs_layout_select'                => 'layout-7',
			'betterdocs_single_layout_select'              => 'layout-8',
			'betterdocs_doc_page_background_color'         => '#ffffff',
			'betterdocs_doc_page_background_image'         => '',
			'betterdocs_doc_page_background_property'      => '',
			'betterdocs_doc_page_background_size'          => '',
			'betterdocs_doc_page_background_repeat'        => '',
			'betterdocs_doc_page_background_attachment'    => '',
			'betterdocs_doc_page_background_position'      => '',
			'betterdocs_doc_page_content_padding'          => '',
			'betterdocs_doc_page_content_padding_top'      => '50',
			'betterdocs_doc_page_content_padding_right'    => '0',
			'betterdocs_doc_page_content_padding_bottom'   => '50',
			'betterdocs_doc_page_content_padding_left'     => '0',
			'betterdocs_doc_page_content_width'            => '100',
			'betterdocs_doc_page_content_max_width'        => '1400',
			'betterdocs_doc_page_column_settings'          => '',
			'betterdocs_sleek_docs_page_column_number'     => '4',
			'betterdocs_doc_page_column_space'             => '15',
			'betterdocs_doc_page_column_padding'           => '',
			'betterdocs_doc_page_column_padding_top'       => '20',
			'betterdocs_doc_page_column_padding_right'     => '20',
			'betterdocs_doc_page_column_padding_bottom'    => '20',
			'betterdocs_doc_page_column_padding_left'      => '20',
			'betterdocs_doc_page_column_padding_layout_7'  => '',
			'betterdocs_doc_page_column_padding_top_layout_7' => '40',
			'betterdocs_doc_page_column_padding_right_layout_7' => '20',
			'betterdocs_doc_page_column_padding_bottom_layout_7' => '40',
			'betterdocs_doc_page_column_padding_left_layout_7' => '20',
			'column_background_color_layout_7'             => '#fff',
			'betterdocs_doc_page_column_hover_bg_color_layout_7' => '#F6FEF9',
			'betterdocs_category_title_tag'                => 'h2',
			'betterdocs_doc_page_column_bg_color'          => '#fff',
			'betterdocs_doc_page_column_bg_color2'         => '#f8f8fc',
			'betterdocs_doc_page_column_hover_bg_color'    => '#fff',
			'betterdocs_doc_page_column_borderr'           => '',
			'betterdocs_doc_page_column_borderr_topleft'   => '5',
			'betterdocs_doc_page_column_borderr_topright'  => '5',
			'betterdocs_doc_page_column_borderr_bottomright' => '5',
			'betterdocs_doc_page_column_borderr_bottomleft' => '5',
			'betterdocs_doc_page_column_content_space'     => '',
			'betterdocs_doc_page_column_content_space_image' => '20',
			'betterdocs_doc_page_column_content_space_title' => '15',
			'betterdocs_doc_page_column_content_space_desc' => '15',
			'betterdocs_doc_page_column_content_space_counter' => '0',
			'betterdocs_doc_page_cat_icon_size_layout1'    => '32',
			'betterdocs_doc_page_cat_icon_size_layout2'    => '80',
			'betterdocs_doc_page_cat_icon_size_layout_7'   => '32',
			'betterdocs_doc_page_cat_title_font_size'      => '20',
			'betterdocs_doc_page_cat_title_font_size_layout_7' => '24',
			'betterdocs_doc_page_show_category_icon'       => true,
			'betterdocs_doc_page_cat_title_color'          => '#528ffe',
			'betterdocs_doc_page_cat_title_color2'         => '#333333',
			'betterdocs_doc_page_cat_title_color_layout_7' => '#1D2939',
			'column_border_color_layout_7'                 => '#EAECF0',
			'betterdocs_doc_page_cat_title_hover_color'    => '',
			'category_title_color_hover_layout_7'          => '#1D2939',
			'betterdocs_doc_page_cat_title_border_color'   => '#528ffe',
			'betterdocs_item_counter_title'                => '',
			'betterdocs_doc_page_item_count_color'         => '#ffffff',
			'betterdocs_doc_page_item_count_color_layout2' => '#707070',
			'betterdocs_doc_page_item_count_color_layout_7' => '#475467',
			'betterdocs_doc_page_item_count_hover_color_layout_7' => '#475467',
			'last_updated_time_layout_7'                   => '',
			'last_updated_time_layout_7_font_size'         => '12',
			'last_updated_time_layout_7_color'             => '#475467',
			'last_updated_time_layout_7_hover_color'       => '#475467',
			'last_updated_time_layout_7_background_color'  => '#FFFCF5',
			'last_updated_time_layout_7_background_hover_color' => '#FFFCF5',
			'content_header_layout_7'                      => '',
			'content_header_background_layout_7'           => '#F9FAFB',
			'archive_category_column_settings_layout_7'    => '',
			'content_header_background_hover_layout_7'     => '#F9FAFB',
			'content_header_background_image_size_layout_7' => '56',
			'content_header_background_title_font_size_layout_7' => '32',
			'content_header_background_title_color_layout_7' => '#1D2939',
			'content_header_background_count_font_size_layout_7' => '16',
			'content_header_background_count_color_layout_7' => '#475467',
			'archive_column_background_color_layout_7'     => '#fff',
			'betterdocs_archive_column_hover_bg_color_layout_7' => '#F6FEF9',
			'betterdocs_archive_page_column_padding_layout_7' => '',
			'betterdocs_archive_page_column_padding_top_layout_7' => '40',
			'betterdocs_archive_page_column_padding_right_layout_7' => '20',
			'betterdocs_archive_page_column_padding_bottom_layout_7' => '40',
			'betterdocs_archive_page_column_padding_left_layout_7' => '20',
			'archive_column_border_color_layout_7'         => '#EAECF0',
			'betterdocs_archive_page_cat_icon_size_layout_7' => '32',
			'betterdocs_archive_page_cat_title_font_size_layout_7' => '24',
			'betterdocs_archive_page_cat_title_color_layout_7' => '#1D2939',
			'archive_category_title_color_hover_layout_7'  => '#1D2939',
			'archive_column_new_tag_background_color_layout_7' => '#F63D68',
			'betterdocs_archive_page_item_count_font_size_layout_7' => '16',
			'archive_betterdocs_doc_page_item_count_color_layout_7' => '#475467',
			'archive_page_item_count_hover_color_layout_7' => '',
			'archive_last_updated_time_layout_7'           => '',
			'archive_last_updated_time_layout_7_font_size' => '12',
			'archive_last_updated_time_layout_7_color'     => '#475467',
			'archive_last_updated_time_layout_7_hover_color' => '#475467',
			'archive_last_updated_time_layout_7_background_color' => '#FFFCF5',
			'archive_last_updated_time_layout_7_background_hover_color' => '#FFFCF5',
			'betterdocs_archive_page_item_count_hover_color_layout_7' => '#475467',
			'archive_docs_list_layout_7'                   => '',
			'archive_docs_list_title_color_layout_7'       => '#1D2939',
			'archive_docs_list_title_hover_color_layout_7' => '#1D2939',
			'archive_docs_list_title_font_size_layout_7'   => '24',
			'archive_docs_list_icon_size_layout_7'         => '32',
			'archive_docs_list_last_updated_time_font_size_layout_7' => '12',
			'archive_docs_list_last_updated_time_font_color_layout_7' => '#475467',
			'archive_docs_list_last_updated_time_font_hover_color_layout_7' => '#475467',
			'archive_docs_list_last_updated_time_background_color_layout_7' => '#FFFCF5',
			'archive_docs_list_last_updated_time_background_hover_color_layout_7' => '#FFFCF5',
			'archive_docs_list_excerpt_font_size_layout_7' => '16',
			'archive_docs_list_excerpt_font_color_layout_7' => '#475467',
			'betterdocs_doc_page_cat_desc'                 => false,
			'betterdocs_doc_page_box_border_bottom'        => false,
			'betterdocs_doc_page_box_border_bottom_size'   => '4',
			'betterdocs_doc_page_box_border_bottom_color'  => '#FF7D67',
			'betterdocs_doc_page_cat_desc_color'           => '#566e8b',
			'betterdocs_doc_page_item_count_bg_color'      => '#528ffe',
			'betterdocs_doc_page_item_count_inner_bg_color' => 'rgba(82,143,254,0.44)',
			'betterdocs_doc_page_item_counter_size'        => '30',
			'betterdocs_doc_page_item_count_font_size'     => '15',
			'betterdocs_doc_page_item_count_font_size_layout_7' => '16',
			'betterdocs_doc_page_article_list_settings'    => '',
			'betterdocs_doc_page_article_list_color'       => '#566e8b',
			'betterdocs_doc_page_article_list_hover_color' => '#566e8b',
			'betterdocs_doc_page_article_list_bg_color'    => '#ffffff',
			'betterdocs_doc_page_article_list_icon'        => '',
			'betterdocs_doc_page_article_list_button_bg_color' => 'rgba(255,255,255,0)',
			'betterdocs_doc_page_article_list_font_size'   => '15',
			'betterdocs_doc_page_list_icon_color'          => '#566e8b',
			'betterdocs_doc_page_list_icon_font_size'      => '15',
			'betterdocs_doc_page_article_list_margin'      => '',
			'betterdocs_doc_page_article_list_margin_top'  => '10',
			'betterdocs_doc_page_article_list_margin_right' => '10',
			'betterdocs_doc_page_article_list_margin_bottom' => '10',
			'betterdocs_doc_page_article_list_margin_left' => '10',
			'betterdocs_doc_page_article_subcategory_color' => '#566e8b',
			'betterdocs_doc_page_article_subcategory_hover_color' => '#566e8b',
			'betterdocs_doc_page_article_subcategory_font_size' => '17',
			'betterdocs_doc_page_subcategory_icon_color'   => '#566e8b',
			'betterdocs_doc_page_subcategory_icon_font_size' => '15',
			'betterdocs_doc_page_subcategory_article_list_color' => '#566e8b',
			'betterdocs_doc_page_subcategory_article_list_hover_color' => '#566e8b',
			'betterdocs_doc_page_subcategory_article_list_icon_color' => '#566e8b',
			'betterdocs_doc_page_explore_btn'              => '',
			'betterdocs_doc_page_explore_btn_bg_color'     => '#ffffff',
			'betterdocs_doc_page_explore_btn_color'        => '#528ffe',
			'betterdocs_doc_page_explore_btn_border_color' => '#528ffe',
			'betterdocs_doc_page_explore_btn_font_size'    => '16',
			'betterdocs_doc_page_explore_btn_padding'      => '',
			'betterdocs_doc_page_explore_btn_padding_top'  => '10',
			'betterdocs_doc_page_explore_btn_padding_right' => '20',
			'betterdocs_doc_page_explore_btn_padding_bottom' => '10',
			'betterdocs_doc_page_explore_btn_padding_left' => '20',
			'betterdocs_doc_page_explore_btn_borderr'      => '',
			'betterdocs_doc_page_explore_btn_borderr_topleft' => '50',
			'betterdocs_doc_page_explore_btn_borderr_topright' => '50',
			'betterdocs_doc_page_explore_btn_borderr_bottomright' => '50',
			'betterdocs_doc_page_explore_btn_borderr_bottomleft' => '50',
			'betterdocs_doc_page_explore_btn_hover_bg_color' => '#528ffe',
			'betterdocs_doc_page_explore_btn_hover_color'  => '#fff',
			'betterdocs_doc_page_explore_btn_hover_border_color' => '#528ffe',
			'betterdocs_doc_author_section'                => '',
			'betterdocs_doc_author_enable'                 => false,
			'betterdocs_doc_author_enable_layout_9'        => true,
			'betterdocs_doc_author_date'                   => true,
			'betterdocs_doc_estimate_reading_time_section' => '',
			'betterdocs_doc_single_content_est_reading_bg_color' => '#FFFFFF',
			'betterdocs_doc_single_content_est_reading_bg_color_layout_8_9' => '#F9FAFB',
			'betterdocs_doc_single_content_est_reading_border_radius' => '16',
			'betterdocs_doc_single_content_est_reading_font_weight' => 'normal',
			'betterdocs_doc_single_content_est_reading_icon_font_size' => '14',
			'betterdocs_doc_single_content_est_reading_icon_color' => '#667085',
			'betterdocs_doc_single_content_est_reading_color' => '#667085',
			'betterdocs_doc_single_content_est_reading_font_size' => '14',
			'betterdocs_doc_single_content_est_reading_margin' => '',
			'betterdocs_doc_single_content_est_reading_margin_top' => '0',
			'betterdocs_doc_single_content_est_reading_margin_right' => '0',
			'betterdocs_doc_single_content_est_reading_margin_bottom' => '24',
			'betterdocs_doc_single_content_est_reading_margin_left' => '0',
			'betterdocs_doc_single_content_est_reading_padding' => '',
			'betterdocs_doc_single_content_est_reading_padding_top' => '5',
			'betterdocs_doc_single_content_est_reading_padding_right' => '10',
			'betterdocs_doc_single_content_est_reading_padding_bottom' => '5',
			'betterdocs_doc_single_content_est_reading_padding_left' => '10',
			'betterdocs_doc_single_content_area_bg_color'  => 'rgba(255,255,255,0)',
			'betterdocs_doc_single_content_area_padding'   => '',
			'betterdocs_doc_single_content_area_padding_top' => '30',
			'betterdocs_doc_single_content_area_padding_right' => '25',
			'betterdocs_doc_single_content_area_padding_bottom' => '30',
			'betterdocs_doc_single_content_area_padding_left' => '25',
			'betterdocs_doc_single_post_content_padding'   => '',
			'betterdocs_doc_single_post_content_padding_top' => '20',
			'betterdocs_doc_single_post_content_padding_right' => '20',
			'betterdocs_doc_single_post_content_padding_bottom' => '20',
			'betterdocs_doc_single_post_content_padding_left' => '20',
			'betterdocs_doc_single_2_post_content_padding' => '',
			'betterdocs_doc_single_2_post_content_padding_top' => '0',
			'betterdocs_doc_single_2_post_content_padding_right' => '0',
			'betterdocs_doc_single_2_post_content_padding_bottom' => '0',
			'betterdocs_doc_single_2_post_content_padding_left' => '0',
			'betterdocs_doc_single_3_post_content_padding' => '',
			'betterdocs_doc_single_3_post_content_padding_top' => '20',
			'betterdocs_doc_single_3_post_content_padding_right' => '20',
			'betterdocs_doc_single_3_post_content_padding_bottom' => '20',
			'betterdocs_doc_single_3_post_content_padding_left' => '20',
			'betterdocs_single_doc_title'                  => '',
			'betterdocs_post_title_tag'                    => 'h1',
			'betterdocs_post_title_text_transform'         => 'uppercase',
			'betterdocs_single_doc_title_font_size'        => '36',
			'betterdocs_single_doc_title_color'            => '#3f5876',
			'betterdocs_single_doc_breadcrumbs_font_size'  => '16',
			'betterdocs_single_doc_breadcrumb_color'       => '#566e8b',
			'betterdocs_single_doc_breadcrumb_hover_color' => '#566e8b',
			'betterdocs_single_doc_breadcrumb_speretor_color' => '#566e8b',
			'betterdocs_single_doc_breadcrumb_active_item_color' => '#528fff',
			'betterdocs_doc_single_toc_title'              => '',
			'betterdocs_sticky_toc_width'                  => '320',
			'betterdocs_sticky_toc_zindex'                 => '2',
			'betterdocs_sticky_toc_margin_top'             => '0',
			'betterdocs_toc_bg_color'                      => '#fff',
			'betterdocs_doc_single_toc_padding'            => '',
			'betterdocs_doc_single_toc_padding_top'        => '20',
			'betterdocs_doc_single_toc_padding_right'      => '25',
			'betterdocs_doc_single_toc_padding_bottom'     => '20',
			'betterdocs_doc_single_toc_padding_left'       => '20',
			'betterdocs_toc_title_color'                   => '#3f5876',
			'betterdocs_toc_title_font_size'               => '18',
			'betterdocs_toc_list_item_color'               => '#566e8b',
			'betterdocs_toc_list_item_hover_color'         => '#528fff',
			'betterdocs_toc_active_item_color'             => '#528fff',
			'betterdocs_toc_list_item_font_size'           => '14',
			'betterdocs_doc_single_toc_list_margin'        => '',
			'betterdocs_doc_single_toc_list_margin_top'    => '5',
			'betterdocs_doc_single_toc_list_margin_right'  => '0',
			'betterdocs_doc_single_toc_list_margin_bottom' => '5',
			'betterdocs_doc_single_toc_list_margin_left'   => '0',
			'betterdocs_toc_list_number_color'             => '#566e8b',
			'betterdocs_toc_list_number_font_size'         => '12',
			'betterdocs_toc_margin_bottom'                 => '20',
			'betterdocs_doc_single_entry_content'          => '',
			'betterdocs_single_content_font_size'          => '16',
			'betterdocs_single_content_font_color'         => '#4d4d4d',
			'betterdocs_doc_single_entry_footer'           => '',
			'betterdocs_social_share_title'                => '',
			'betterdocs_post_social_share'                 => true,
			'betterdocs_social_sharing_text'               => __( 'Share This Article :', 'betterdocs' ),
			'betterdocs_post_social_share_text_color'      => '#566e8b',
			'betterdocs_post_social_share_facebook'        => true,
			'betterdocs_post_social_share_twitter'         => true,
			'betterdocs_post_social_share_linkedin'        => true,
			'betterdocs_post_social_share_pinterest'       => true,
			'betterdocs_single_doc_feedback_icon_font_size' => '26',
			'betterdocs_single_doc_feedback_icon'          => '',
			'betterdocs_single_doc_feedback_link_color'    => '#566e8b',
			'betterdocs_single_doc_feedback_link_hover_color' => '#566e8b',
			'betterdocs_single_doc_feedback_link_font_size' => '15',
			'betterdocs_feedback_form_title_tag'           => 'h2',
			'betterdocs_single_doc_feedback_title_font_size' => '21',
			'betterdocs_single_doc_feedback_title_color'   => '#3f5876',
			'betterdocs_single_doc_navigation_color'       => '#3f5876',
			'betterdocs_single_doc_navigation_hover_color' => '#3f5876',
			'betterdocs_single_doc_navigation_font_size'   => '16',
			'betterdocs_single_doc_navigation_arrow_color' => '#5edf8e',
			'betterdocs_single_doc_navigation_arrow_font_size' => '16',
			'betterdocs_single_doc_lu_time_color'          => '#566e8b',
			'betterdocs_single_doc_lu_time_font_size'      => '14',
			'betterdocs_single_doc_powered_by_color'       => '#201d3a',
			'betterdocs_single_doc_powered_by_font_size'   => '14',
			'betterdocs_single_doc_powered_by_link_color'  => '#528fff',
			'betterdocs_sidebar_bg_color'                  => '#ffffff',
			'betterdocs_sidebar_padding'                   => '',
			'betterdocs_sidebar_padding_top'               => '0',
			'betterdocs_sidebar_padding_right'             => '0',
			'betterdocs_sidebar_padding_bottom'            => '0',
			'betterdocs_sidebar_padding_left'              => '0',
			'betterdocs_sidebar_borderr'                   => '',
			'betterdocs_sidebar_borderr_topleft'           => '5',
			'betterdocs_sidebar_borderr_topright'          => '5',
			'betterdocs_sidebar_borderr_bottomright'       => '5',
			'betterdocs_sidebar_borderr_bottomleft'        => '5',
			'betterdocs_sidebar_title'                     => '',
			'betterdocs_sidebar_title_tag'                 => 'h2',
			'betterdocs_sidebar_icon_size'                 => '24',
			'betterdocs_sidebar_title_bg_color'            => '#ffffff',
			'betterdocs_sidebar_title_color'               => '#3f5876',
			'betterdocs_sidebar_title_hover_color'         => '#3f5876',
			'betterdocs_sidebar_active_title_color'        => '#3f5876',
			'betterdocs_sidebar_active_cat_background_color' => 'rgba(90, 148, 255, .1)',
			'betterdocs_sidebar_active_cat_border_color'   => '#528fff',
			'betterdocs_sidebar_title_font_size'           => '16',
			'betterdocs_sidebar_title_padding'             => '',
			'betterdocs_sidebar_title_padding_top'         => '10',
			'betterdocs_sidebar_title_padding_right'       => '15',
			'betterdocs_sidebar_title_padding_bottom'      => '10',
			'betterdocs_sidebar_title_padding_left'        => '15',
			'betterdocs_sidebar_title_margin'              => '',
			'betterdocs_sidebar_title_margin_top'          => '5',
			'betterdocs_sidebar_title_margin_right'        => '0',
			'betterdocs_sidebar_title_margin_bottom'       => '5',
			'betterdocs_sidebar_title_margin_left'         => '0',
			'betterdocs_sidebar_content'                   => '',
			'betterdocs_sidbebar_item_list_bg_color'       => '#ffffff',
			'betterdocs_sidbebar_item_list_icon'           => '',
			'betterdocs_sidebar_item_counter_title'        => '',
			'betterdocs_sidbebar_item_count_bg_color'      => '#528ffe',
			'betterdocs_sidbebar_item_count_inner_bg_color' => 'rgba(82, 143, 255, 0.2)',
			'betterdocs_sidebar_item_counter_size'         => '30',
			'betterdocs_sidebar_item_count_color'          => '#ffffff',
			'betterdocs_sidebat_item_count_font_size'      => '12',
			'betterdocs_sidebar_list_item_color'           => '#566e8b',
			'betterdocs_sidebar_list_item_hover_color'     => '#528fff',
			'betterdocs_sidebar_active_list_item_color'    => '#528fff',
			'betterdocs_sidebar_list_item_font_size'       => '14',
			'betterdocs_sidebar_list_item_margin'          => '',
			'betterdocs_sidebar_list_item_margin_top'      => '10',
			'betterdocs_sidebar_list_item_margin_right'    => '10',
			'betterdocs_sidebar_list_item_margin_bottom'   => '10',
			'betterdocs_sidebar_list_item_margin_left'     => '10',
			'betterdocs_sidebar_list_icon_color'           => '#566e8b',
			'betterdocs_sidebar_list_icon_font_size'       => '14',
			'betterdocs_archive_layout_select'             => 'layout-7',
			'betterdocs_archive_page_background_color'     => '',
			'betterdocs_archive_page_background_image'     => '',
			'betterdocs_archive_page_background_property'  => '',
			'betterdocs_archive_page_background_size'      => '',
			'betterdocs_archive_page_background_repeat'    => '',
			'betterdocs_archive_page_background_attachment' => '',
			'betterdocs_archive_page_background_position'  => '',
			'betterdocs_archive_content_area_max_width'    => '1400',
			'betterdocs_archive_content_area_width'        => '100',
			'betterdocs_archive_content_area_settings'     => '',
			'betterdocs_archive_content_background_color'  => '#ffffff',
			'betterdocs_archive_content_margin'            => '',
			'betterdocs_archive_content_margin_top'        => '0',
			'betterdocs_archive_content_margin_right'      => '0',
			'betterdocs_archive_content_margin_bottom'     => '0',
			'betterdocs_archive_content_margin_left'       => '0',
			'category_archive_padding'                     => '', //@since betterdocs-revamped version
			'category_archive_padding_top'                 => '30', //@since betterdocs-revamped version
			'category_archive_padding_right'               => '25', //@since betterdocs-revamped version
			'category_archive_padding_bottom'              => '30', //@since betterdocs-revamped version
			'category_archive_padding_left'                => '25', //@since betterdocs-revamped version
			'betterdocs_archive_content_padding'           => '',
			'betterdocs_archive_content_padding_top'       => '30',
			'betterdocs_archive_content_padding_right'     => '30',
			'betterdocs_archive_content_padding_bottom'    => '30',
			'betterdocs_archive_content_padding_left'      => '30',
			'betterdocs_archive_content_border_radius'     => '5',
			'betterdocs_archive_title_color'               => '#566e8b',
			'betterdocs_archive_title_margin'              => '',
			'betterdocs_archive_title_tag'                 => 'h3',
			'betterdocs_archive_title_margin_top'          => '0',
			'betterdocs_archive_title_margin_right'        => '0',
			'betterdocs_archive_title_margin_bottom'       => '20',
			'betterdocs_archive_title_margin_left'         => '0',
			'betterdocs_archive_title_font_size'           => '20',
			'betterdocs_archive_description_color'         => '#566e8b',
			'betterdocs_archive_description_margin'        => '',
			'betterdocs_archive_description_margin_top'    => '0',
			'betterdocs_archive_description_margin_right'  => '0',
			'betterdocs_archive_description_margin_bottom' => '20',
			'betterdocs_archive_description_margin_left'   => '0',
			'betterdocs_archive_description_font_size'     => '14',
			'betterdocs_archive_list_icon'                 => '',
			'betterdocs_archive_list_icon_color'           => '#566e8b',
			'betterdocs_archive_list_icon_font_size'       => '16',
			'betterdocs_archive_list_item_color'           => '#566e8b',
			'betterdocs_archive_list_item_hover_color'     => '#528ffe',
			'betterdocs_archive_list_item_font_size'       => '14',
			'betterdocs_archive_article_list_margin'       => '',
			'betterdocs_archive_article_list_margin_top'   => '10',
			'betterdocs_archive_article_list_margin_right' => '0',
			'betterdocs_archive_article_list_margin_bottom' => '10',
			'betterdocs_archive_article_list_margin_left'  => '0',
			'betterdocs_archive_article_subcategory_color' => '#566e8b',
			'betterdocs_archive_article_subcategory_hover_color' => '#566e8b',
			'betterdocs_archive_article_subcategory_font_size' => '17',
			'betterdocs_archive_subcategory_icon_color'    => '#566e8b',
			'betterdocs_archive_subcategory_icon_font_size' => '15',
			'betterdocs_archive_subcategory_article_list_color' => '#566e8b',
			'betterdocs_archive_subcategory_article_list_hover_color' => '#566e8b',
			'betterdocs_archive_subcategory_article_list_icon_color' => '#566e8b',
			'betterdocs_live_search_heading_switch'        => true,
			'betterdocs_live_search_heading'               => __( 'How can we help you?', 'betterdocs' ),
			'betterdocs_live_search_heading_font_size'     => 40,
			'betterdocs_live_search_heading_font_size_layout_2' => 36,
			'betterdocs_live_search_subheading'            => '',
			'betterdocs_live_search_subheading_font_size'  => 16,
			'betterdocs_live_search_subheading_font_size_layout_2' => '16',
			'betterdocs_live_search_subheading_font_color_layout_2' => '#333',
			'betterdocs_live_search_heading_font_color'    => '#566e8b',
			'betterdocs_live_search_heading_font_color_layout_2' => '#475467',
			'heading_margin_layout_2'                      => '',
			'betterdocs_search_heading_margin_top_layout_2' => '0',
			'betterdocs_search_heading_margin_right_layout_2' => '0',
			'betterdocs_search_heading_margin_bottom_layout_2' => '0',
			'betterdocs_search_heading_margin_left_layout_2' => '0',
			'betterdocs_search_subheading_margin_layout_2' => '',
			'betterdocs_search_subheading_margin_top_layout_2' => '15',
			'betterdocs_search_subheading_margin_right_layout_2' => '0',
			'betterdocs_search_subheading_margin_bottom_layout_2' => '0',
			'betterdocs_search_subheading_margin_left_layout_2' => '0',
			'betterdocs_live_search_heading_tag'           => 'h2',
			'betterdocs_live_search_subheading_tag'        => 'h3',
			'betterdocs_live_search_background_color_layout_2' => '#F9FAFB',
			'background_live_search_image_layout_2'        => '',
			'betterdocs_live_search_background_property_layout_2' => '',
			'betterdocs_live_search_background_size_layout_2' => '',
			'betterdocs_live_search_background_repeat_layout_2' => '',
			'betterdocs_live_search_background_attachment_layout_2' => '',
			'betterdocs_live_search_background_position_layout_2' => '',
			'betterdocs_live_search_margin_layout_2'       => '',
			'betterdocs_live_search_margin_top_layout_2'   => '57',
			'betterdocs_live_search_margin_bottom_layout_2' => '0',
			'betterdocs_live_search_padding_layout_2'      => '',
			'betterdocs_live_search_padding_top_layout_2'  => '50',
			'betterdocs_live_search_padding_right_layout_2' => '0',
			'betterdocs_live_search_padding_bottom_layout_2' => '50',
			'betterdocs_live_search_padding_left_layout_2' => '0',
			'betterdocs_search_field_settings_layout_2'    => '',
			'betterdocs_search_field_background_color_layout_2' => '#FFFFFF',
			'betterdocs_search_placeholder_color_layout_2' => '#667085',
			'betterdocs_search_field_padding_layout_2'     => '',
			'betterdocs_search_field_padding_top_layout_2' => '12',
			'betterdocs_search_field_padding_right_layout_2' => '12',
			'betterdocs_search_field_padding_bottom_layout_2' => '12',
			'betterdocs_search_field_padding_left_layout_2' => '20',
			// 'betterdocs_search_button_section_layout_2'                           => '',
			'betterdocs_new_search_button_font_size_layout_2' => '16',
			'betterdocs_new_search_button_font_weight_layout_2' => '500',
			'betterdocs_new_search_button_text_transform_layout_2' => 'capitalize',
			'betterdocs_search_button_text_color_layout_2' => '#FFF',
			'betterdocs_search_button_background_color_layout_2' => '#667085',
			'betterdocs_search_button_background_color_hover_layout_2' => '#667085',
			'betterdocs_search_button_borderr_radius_layout_2' => '',
			'betterdocs_search_button_borderr_left_top_layout_2' => '6',
			'betterdocs_search_button_borderr_right_top_layout_2' => '6',
			'betterdocs_search_button_borderr_left_bottom_layout_2' => '6',
			'betterdocs_search_button_borderr_right_bottom_layout_2' => '6',
			'betterdocs_search_button_padding_layout_2'    => '',
			'betterdocs_search_button_padding_top_layout_2' => '10',
			'betterdocs_search_button_padding_right_layout_2' => '32',
			'betterdocs_search_button_padding_bottom_layout_2' => '10',
			'betterdocs_search_button_padding_left_layout_2' => '32',
			'betterdocs_search_heading_margin'             => '',
			'betterdocs_search_heading_margin_top'         => '0',
			'betterdocs_search_heading_margin_right'       => '0',
			'betterdocs_search_heading_margin_bottom'      => '20',
			'betterdocs_search_heading_margin_left'        => '0',
			'betterdocs_live_search_subheading_font_color' => '#566e8b',
			'betterdocs_search_subheading_margin'          => '',
			'betterdocs_search_subheading_margin_top'      => '0',
			'betterdocs_search_subheading_margin_right'    => '0',
			'betterdocs_search_subheading_margin_bottom'   => '20',
			'betterdocs_search_subheading_margin_left'     => '0',
			'betterdocs_live_search_background_color'      => '#f7f7f7',
			'betterdocs_live_search_background_image'      => '',
			'betterdocs_live_search_background_property'   => '',
			'betterdocs_live_search_background_size'       => '',
			'betterdocs_live_search_background_repeat'     => '',
			'betterdocs_live_search_background_attachment' => '',
			'betterdocs_live_search_background_position'   => '',
			'betterdocs_live_search_padding'               => '',
			'betterdocs_live_search_padding_top'           => '50',
			'betterdocs_live_search_padding_right'         => '20',
			'betterdocs_live_search_padding_bottom'        => '50',
			'betterdocs_live_search_padding_left'          => '20',
			'betterdocs_search_field_settings'             => '',
			'betterdocs_search_field_background_color'     => '#ffffff',
			'betterdocs_search_field_font_size'            => '16',
			'betterdocs_search_field_color'                => '#595959',
			'betterdocs_search_placeholder_color'          => '#595959',
			'betterdocs_search_field_padding'              => '',
			'betterdocs_search_field_padding_top'          => '22',
			'betterdocs_search_field_padding_right'        => '15',
			'betterdocs_search_field_padding_bottom'       => '22',
			'betterdocs_search_field_padding_left'         => '15',
			'betterdocs_search_field_border_radius'        => '8',
			'betterdocs_search_icon_color'                 => '#444b54',
			'betterdocs_search_icon_hover_color'           => '#444b54',
			'betterdocs_search_close_icon_color'           => '#ff697b',
			'betterdocs_search_close_icon_border_color'    => '#444b54',
			'betterdocs_search_icon_size'                  => '30',
			'betterdocs_search_result_settings'            => '',
			'betterdocs_search_result_width'               => '100',
			'betterdocs_search_result_max_width'           => '800',
			'betterdocs_search_result_background_color'    => '#fff',
			'betterdocs_search_result_border_color'        => '#f1f1f1',
			'betterdocs_search_result_item_font_size'      => '16',
			'betterdocs_search_result_item_font_color'     => '#444444',
			'betterdocs_search_result_item_cat_font_color' => '#444444',
			'betterdocs_search_result_item_padding'        => '',
			'betterdocs_search_result_item_padding_top'    => '10',
			'betterdocs_search_result_item_padding_right'  => '10',
			'betterdocs_search_result_item_padding_bottom' => '10',
			'betterdocs_search_result_item_padding_left'   => '10',
			'betterdocs_search_result_item_border_color'   => '#f5f5f5',
			'betterdocs_search_result_item_hover_font_color' => '#444444',
			'betterdocs_search_result_item_hover_background_color' => '#f5f5f5',
			'betterdocs_popular_docs_text'                 => __( 'Popular Docs', 'betterdocs' ),
			'betterdocs_popular_docs_number'               => '10',
			'betterdocs_live_search_margin'                => '0',
			'betterdocs_live_search_margin_top'            => '0',
			'betterdocs_live_search_margin_right'          => '0',
			'betterdocs_live_search_margin_bottom'         => '0',
			'betterdocs_live_search_margin_left'           => '0',
			'betterdocs_doc_page_explore_btn_border_width' => '1',
			'betterdocs_doc_page_item_count_border_color'  => '#ffffff',
			'betterdocs_doc_page_article_list_padding'     => '',
			'betterdocs_doc_page_article_list_padding_top' => '0',
			'betterdocs_doc_page_article_list_padding_right' => '0',
			'betterdocs_doc_page_article_list_padding_bottom' => '0',
			'betterdocs_doc_page_article_list_padding_left' => '0',
			'betterdocs_doc_page_item_count_border_type'   => 'none',
			'betterdocs_live_search_custom_background_switch' => false,
			'betterdocs_live_search_custom_background_width' => '100',
			'betterdocs_live_search_custom_background_height' => '100',
			'betterdocs_doc_page_explore_btn_margin'       => '',
			'betterdocs_doc_page_explore_btn_margin_top'   => '10',
			'betterdocs_doc_page_explore_btn_margin_right' => '20',
			'betterdocs_doc_page_explore_btn_margin_bottom' => '10',
			'betterdocs_doc_page_explore_btn_margin_left'  => '20',
			'betterdocs_doc_page_item_count_inner_border_width' => '',
			'betterdocs_doc_page_item_count_inner_border_width_top' => '0',
			'betterdocs_doc_page_item_count_inner_border_width_right' => '0',
			'betterdocs_doc_page_item_count_inner_border_width_bottom' => '0',
			'betterdocs_doc_page_item_count_inner_border_width_left' => '0',
			'betterdocs_doc_page_cat_title_padding_bottom' => '20',
			'betterdocs_doc_page_article_list_padding_2'   => '',
			'betterdocs_doc_page_article_list_padding_top_2' => '0',
			'betterdocs_doc_page_article_list_padding_right_2' => '0',
			'betterdocs_doc_page_article_list_padding_bottom_2' => '0',
			'betterdocs_doc_page_article_list_padding_left_2' => '0',
			'betterdocs_doc_single_toc_margin'             => '',
			'betterdocs_doc_single_toc_margin_top'         => '0',
			'betterdocs_doc_single_toc_margin_right'       => '0',
			'betterdocs_doc_single_toc_margin_bottom'      => '0',
			'betterdocs_doc_single_toc_margin_left'        => '0',
			'betterdocs_doc_single_content_area_bg_image'  => '',
			'betterdocs_doc_single_content_bg_property'    => '',
			'betterdocs_doc_single_content_bg_property_size' => '',
			'betterdocs_doc_single_content_bg_property_repeat' => '',
			'betterdocs_doc_single_content_bg_property_attachment' => '',
			'betterdocs_doc_single_content_bg_property_position' => '',
			'reactions_background_color'                   => '#fff',
			'betterdocs_reactions_title'                   => '',
			'betterdocs_post_reactions'                    => true,
			'betterdocs_post_reactions_happy'              => true,
			'betterdocs_post_reactions_happy_icon'         => '',
			'betterdocs_post_reactions_normal'             => true,
			'betterdocs_post_reactions_normal_icon'        => '',
			'betterdocs_post_reactions_sad'                => true,
			'betterdocs_post_reactions_sad_icon'           => '',
			'betterdocs_post_reactions_text'               => __( 'What are your feelings', 'betterdocs' ),
			'betterdocs_post_reactions_text_2'             => __( 'Was it helpful ?', 'betterdocs' ),
			'betterdocs_post_reactions_text_color'         => '#566e8b',
			'betterdocs_post_reactions_icon_color'         => '#00b88a',
			'betterdocs_post_reactions_icon_hover_bg_color' => '#fff',
			'betterdocs_post_reactions_icon_svg_color'     => '#fff',
			'betterdocs_post_reactions_icon_hover_svg_color' => '#00b88a',
			'betterdocs_faq_switch'                        => true,
			'betterdocs_select_specific_faq'               => 'all',
			'betterdocs_select_faq_template'               => 'layout-3',
			'betterdocs_faq_title_text'                    => __( 'Frequently Asked Questions', 'betterdocs' ),
			'betterdocs_faq_title_margin'                  => [
				'input1' => 0,
				'input2' => 0,
				'input3' => 0,
				'input4' => 0
			],
			'betterdocs_faq_title_color'                   => '#15063F',
			'betterdocs_faq_title_font_size'               => '30',
			'betterdocs_faq_category_title_color'          => '#15063F',
			'betterdocs_faq_category_name_font_size'       => '25',
			'betterdocs_faq_category_name_font_color'      => '#15063F',
			'betterdocs_faq_category_name_padding'         => [
				'input1' => 20,
				'input2' => 20,
				'input3' => 20,
				'input4' => 20
			],
			'betterdocs_faq_list_color'                    => '#2f3b48',
			'betterdocs_faq_list_background_color'         => '#f0f1f5',
			'betterdocs_faq_list_font_size'                => '17',
			'betterdocs_faq_list_padding'                  => [
				'input1' => 20,
				'input2' => 20,
				'input3' => 20,
				'input4' => 20
			],
			'betterdocs_faq_list_content_background_color' => '#fbfcff',
			'betterdocs_faq_category_title_color_layout_2' => '#15063F',
			'betterdocs_faq_category_name_font_size_layout_2' => '25',
			'betterdocs_faq_category_name_padding_layout_2' => [
				'input1' => 20,
				'input2' => 20,
				'input3' => 20,
				'input4' => 20
			],
			'betterdocs_faq_list_color_layout_2'           => '#2f3b48',
			'betterdocs_faq_list_background_color_layout_2' => '#fff',
			'betterdocs_faq_list_content_background_color_layout_2' => '#fff',
			'betterdocs_faq_list_font_size_layout_2'       => '17',
			'betterdocs_faq_list_padding_layout_2'         => [
				'input1' => 20,
				'input2' => 20,
				'input3' => 20,
				'input4' => 20
			],
			'betterdocs_faq_list_content_font_size'        => '15',
			'betterdocs_faq_list_content_font_size_layout_2' => '15',
			'betterdocs_faq_list_content_color'            => '#7B7B7B',
			'betterdocs_faq_list_content_color_layout_2'   => '#7B7B7B',
			'betterdocs_faq_section_seperator'             => '',
			'betterdocs_single_doc_attachment_heading'     => '',
			'betterdocs_doc_single_attachment_content_bg_color' => '#fff',
			'betterdocs_doc_single_attachment_content_padding' => '',
			'betterdocs_doc_single_attachment_content_padding_top' => '15',
			'betterdocs_doc_single_attachment_content_padding_right' => '15',
			'betterdocs_doc_single_attachment_content_padding_bottom' => '15',
			'betterdocs_doc_single_attachment_content_padding_left' => 15,
			'betterdocs_doc_single_attachment_content_margin' => '',
			'betterdocs_doc_single_attachment_content_margin_top' => '15',
			'betterdocs_doc_single_attachment_content_margin_right' => '0',
			'betterdocs_doc_single_attachment_content_margin_bottom' => '0',
			'betterdocs_doc_single_attachment_content_margin_left' => '0',
			'betterdocs_doc_single_attachment_label_color' => '#000',
			'betterdocs_doc_single_attachment_list_extension_color' => '#98A2B3',
			'betterdocs_doc_single_attachment_label_padding' => '',
			'betterdocs_doc_single_attachment_label_padding_top' => '0',
			'betterdocs_doc_single_attachment_label_padding_right' => '0',
			'betterdocs_doc_single_attachment_label_padding_bottom' => '0',
			'betterdocs_doc_single_attachment_label_padding_left' => '0',
			'betterdocs_doc_single_attachment_label_margin' => '',
			'betterdocs_doc_single_attachment_label_margin_top' => '0',
			'betterdocs_doc_single_attachment_label_margin_right' => '0',
			'betterdocs_doc_single_attachment_label_margin_bottom' => '15',
			'betterdocs_doc_single_attachment_label_margin_left' => '0',
			'betterdocs_doc_single_attachment_list_color'  => '#98A2B3',
			'betterdocs_doc_single_attachment_list_background_color' => '#FFF',
			'betterdocs_doc_single_attachment_list_padding' => '',
			'betterdocs_doc_single_attachment_list_padding_top' => '8',
			'betterdocs_doc_single_attachment_list_padding_right' => '20',
			'betterdocs_doc_single_attachment_list_padding_bottom' => '8',
			'betterdocs_doc_single_attachment_list_padding_left' => '20',
			'betterdocs_doc_single_attachment_list_margin' => '',
			'betterdocs_doc_single_attachment_list_margin_top' => '0',
			'betterdocs_doc_single_attachment_list_margin_right' => '0',
			'betterdocs_doc_single_attachment_list_margin_bottom' => '0',
			'betterdocs_doc_single_attachment_list_margin_left' => '0',
			'betterdocs_doc_single_related_docs_heading'   => '',
			'betterdocs_doc_single_related_docs_content_bg_color' => '#fff',
			'betterdocs_doc_single_related_docs_content_padding' => '',
			'betterdocs_doc_single_related_docs_content_padding_top' => '15',
			'betterdocs_doc_single_related_docs_content_padding_right' => '15',
			'betterdocs_doc_single_related_docs_content_padding_bottom' => '15',
			'betterdocs_doc_single_related_docs_content_padding_left' => '15',
			'betterdocs_doc_single_related_docs_content_margin' => '',
			'betterdocs_doc_single_related_docs_content_margin_top' => '15',
			'betterdocs_doc_single_related_docs_content_margin_right' => '0',
			'betterdocs_doc_single_related_docs_content_margin_bottom' => '0',
			'betterdocs_doc_single_related_docs_content_margin_left' => '0',
			'betterdocs_doc_single_related_docs_label_color' => '#000',
			'betterdocs_doc_single_related_docs_label_padding' => '',
			'betterdocs_doc_single_related_docs_label_padding_top' => '0',
			'betterdocs_doc_single_related_docs_label_padding_right' => '0',
			'betterdocs_doc_single_related_docs_label_padding_bottom' => '0',
			'betterdocs_doc_single_related_docs_label_padding_left' => '0',
			'betterdocs_doc_single_related_docs_label_margin' => '',
			'betterdocs_doc_single_related_docs_label_margin_top' => '0',
			'betterdocs_doc_single_related_docs_label_margin_right' => '0',
			'betterdocs_doc_single_related_docs_label_margin_bottom' => '15',
			'betterdocs_doc_single_related_docs_label_margin_left' => '0',
			'betterdocs_doc_single_related_docs_list_color' => '#475467',
			'betterdocs_doc_single_related_docs_list_background_color' => '#FFF',
			'betterdocs_doc_single_related_docs_list_padding' => '',
			'betterdocs_doc_single_related_docs_list_padding_top' => '8',
			'betterdocs_doc_single_related_docs_list_padding_right' => '20',
			'betterdocs_doc_single_related_docs_list_padding_bottom' => '8',
			'betterdocs_doc_single_related_docs_list_padding_left' => '20',
			'betterdocs_doc_single_related_docs_list_margin' => '',
			'betterdocs_doc_single_related_docs_list_margin_top' => '0',
			'betterdocs_doc_single_related_docs_list_margin_right' => '0',
			'betterdocs_doc_single_related_docs_list_margin_bottom' => '0',
			'betterdocs_doc_single_related_docs_list_margin_left' => '0',
			'betterdocs_doc_single_attachment_list_font_size' => '14',
			'betterdocs_doc_related_docs_list_font_size'   => '14',
			'betterdocs_doc_single_attachment_list_font_weight' => '400',
			'betterdocs_doc_related_docs_list_font_weight' => '400',
			'betterdocs_doc_single_attachment_list_extension_font_size' => '14',
			'betterdocs_doc_single_attachment_list_extension_font_weight' => '400',

			'encyclopedia_doc_style'                       => 'doc-grid',
			'encyclopedia_letter_style'                    => 'alphabet-big-round-view',
			'encyclopedia_alphabet_list_style'             => 'box',
			'encyclopedia_dictionary_loadmore'             => 'true',
			'encyclopedia_dictionary_docs_loadmore'        => 'true',
			'encyclopedia_dictionary_per_page'             => '5',
			'encyclopedia_dictionary_loadmore_button_text' => 'Load More',
			'encyclopedia_dictionary_learn_more_text'      => 'Learn More',
			'encyclopedia_dictionary_explore_more_text'    => 'Explore [count] More Docs',
			'encyclopedia_dictionary_docs_per_page'        => '10',
			'alphabets_background_color'                   => '#fff',
			'alphabets_link_color'                         => '#667085',
			'alphabets_link_bg_color'                      => '#fff',
			'alphabets_link_active_bg_color'               => '#f5f5f5',
			'alphabets_link_active_color'                  => '#fff',
			'start_letter_color'                           => '#667085',
			'start_letter_bg_color'                        => '#fff',
			'start_letter_inner_bg_color'                  => '#f8f8f8',
			'item_title_color'                             => '#344054',
			'item_excerpt_color'                           => '#667085',
			'item_excerpt_bg_color'                        => '#000',
			'item_excerpt_border_color'                    => '#12B76A',
			'item_link_color'                              => '#667085',
			'explore_more_text_color'                      => '#667085',
			'loadmore_button_text_color'                   => '#ffffff',
			'loadmore_button_bg_color'                     => '#475467',
			'alphabets_link_font_size'                     => '20',
			'start_letter_font_size'                       => '96',
			'item_title_font_size'                         => '20',
			'item_excerpt_font_size'                       => '16',
			'item_link_font_size'                          => '16',
			'explore_more_font_size'                       => '18',
			'loadmore_button_text_font_size'               => '14',
			'betterdocs_sidebar_bg_color_layout_7'         => '#FFF',
			'betterdocs_sidebar_border_color_layout_7'     => '#eaecf0',
			'betterdocs_sidebar_padding_layout_7'          => '',
			'betterdocs_sidebar_padding_top_layout_7'      => '58',
			'betterdocs_sidebar_padding_right_layout_7'    => '24',
			'betterdocs_sidebar_padding_bottom_layout_7'   => '0',
			'betterdocs_sidebar_padding_left_layout_7'     => '24',
			'betterdocs_sidebar_title_layout_7'            => '',
			'betterdocs_sidebar_title_tag_layout_7'        => 'h2',
			'betterdocs_sidebar_icon_size_layout_7'        => '16',
			'betterdocs_sidebar_title_bg_color_layout_7'   => 'rgba(255,255,255,0.5)',
			'betterdocs_sidebar_title_color_layout_7'      => '#344054',
			'betterdocs_sidebar_title_hover_color_layout_7' => '#344054',
			'betterdocs_sidebar_active_title_color_layout_7' => '#344054',
			'betterdocs_sidebar_active_cat_background_color_layout_7' => 'rgba(255,255,255,0.5)',
			'betterdocs_sidbebar_list_bg_color_layout_7'   => 'rgba(255,255,255,0.5)',
			'betterdocs_sidebar_active_cat_border_color_layout_7' => '#D0D5DD',
			'betterdocs_sidebar_title_font_size_layout_7'  => '16',
			'betterdocs_sidebar_title_padding_layout_7'    => '',
			'betterdocs_sidebar_title_padding_top_layout_7' => '8',
			'betterdocs_sidebar_title_padding_right_layout_7' => '8',
			'betterdocs_sidebar_title_padding_bottom_layout_7' => '8',
			'betterdocs_sidebar_title_padding_left_layout_7' => '8',
			'betterdocs_sidebar_title_margin_layout_7'     => '',
			'betterdocs_sidebar_title_margin_top_layout_7' => '0',
			'betterdocs_sidebar_title_margin_right_layout_7' => '0',
			'betterdocs_sidebar_title_margin_bottom_layout_7' => '0',
			'betterdocs_sidebar_title_margin_left_layout_7' => '0',
			'betterdocs_sidebar_content_layout_7'          => '',
			'betterdocs_sidebar_item_counter_title_layout_7' => '',
			'betterdocs_sidebar_item_counter_size_layout_7' => '20',
			'betterdocs_sidebar_item_count_color_layout_7' => '#344054',
			'betterdocs_sidebar_list_item_color_layout_7'  => '#667085',
			'betterdocs_sidebar_list_item_hover_color_layout_7' => '#667085',
			// 'betterdocs_sidebar_active_list_item_color_layout_7'                  => '',
			'betterdocs_sidebar_list_item_font_size_layout_7' => '14',
			'betterdocs_sidebar_list_item_margin_layout_7' => '',
			'betterdocs_sidebar_list_item_margin_top_layout_7' => '0',
			'betterdocs_sidebar_list_item_margin_right_layout_7' => '0',
			'betterdocs_sidebar_list_item_margin_bottom_layout_7' => '0',
			'betterdocs_sidebar_list_item_margin_left_layout_7' => '0',
			'betterdocs_sidbebar_item_count_bg_color_layout_7' => '#F2F4F7',
			'betterdocs_sidebat_item_count_font_size_layout_7' => '12',
			'betterdocs_sidbebar_item_list_bg_color_layout_7' => '#00000000',
			'betterdocs_single_doc_feedback_icon_font_size_layout_8_9' => '',
			'betterdocs_post_title_text_transform_layout_8_9' => 'none',
			'betterdocs_single_doc_title_font_size_layout_8_9' => '42',
			'betterdocs_single_doc_title_color_layout_8_9' => '#1D2939',
			'betterdocs_doc_single_toc_title_layout_8_9'   => '',
			// 'betterdocs_sticky_toc_width_layout_8_9' => '',
			// 'betterdocs_sticky_toc_zindex_layout_8_9' => '',
			// 'betterdocs_sticky_toc_margin_top_layout_8_9' => '',
			'betterdocs_toc_bg_color_layout_8_9'           => 'rgba(255,255,255,0.5)',
			'betterdocs_doc_single_toc_padding_layout_8_9' => '',
			'betterdocs_doc_single_toc_padding_top_layout_8_9' => '0',
			'betterdocs_doc_single_toc_padding_right_layout_8_9' => '0',
			'betterdocs_doc_single_toc_padding_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_toc_padding_left_layout_8_9' => '0',
			'betterdocs_doc_single_toc_margin_layout_8_9'  => '',
			'betterdocs_doc_single_toc_margin_top_layout_8_9' => '0',
			'betterdocs_doc_single_toc_margin_right_layout_8_9' => '0',
			'betterdocs_doc_single_toc_margin_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_toc_margin_left_layout_8_9' => '0',
			'betterdocs_toc_title_color_layout_8_9'        => '#667085',
			'betterdocs_toc_title_font_size_layout_8_9'    => '16',
			'betterdocs_toc_list_item_color_layout_8_9'    => '#667085',
			'betterdocs_toc_list_item_hover_color_layout_8_9' => '#667085',
			'betterdocs_toc_active_item_color_layout_8_9'  => '#344054',
			'betterdocs_toc_list_item_font_size_layout_8_9' => '14',
			'betterdocs_doc_single_toc_list_margin_layout_8_9' => '',
			'betterdocs_doc_single_toc_list_margin_top_layout_8_9' => '0',
			'betterdocs_doc_single_toc_list_margin_right_layout_8_9' => '0',
			'betterdocs_doc_single_toc_list_margin_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_toc_list_margin_left_layout_8_9' => '0',
			// 'betterdocs_toc_list_number_color_layout_8_9' => '',
			'betterdocs_toc_list_number_font_size_layout_8_9' => '',
			// 'betterdocs_toc_margin_bottom_layout_8_9' => '',
			'betterdocs_doc_single_content_est_reading_bg_color_layout_8_9' => '#F9FAFB',
			'betterdocs_doc_single_entry_content_layout_8_9' => '',
			'betterdocs_single_content_font_size_layout_8_9' => '18',
			'betterdocs_single_content_font_color_layout_8_9' => '#475467',
			'betterdocs_post_social_share_text_color_color_layout_8_9' => '#1D2939',
			'reactions_background_color_layout_8'          => 'rgba(255,255,255,0.5)',
			'reactions_background_color_layout_9'          => '#F9FAFB',
			'betterdocs_post_reactions_text_color_layout_8_9' => '#475467',
			'betterdocs_post_reactions_icon_color_layout_8_9' => '#F2F4F7',
			'betterdocs_single_doc_navigation_color_layout_8_9' => '#344054',
			'betterdocs_single_doc_navigation_font_size_layout_8_9' => '14',
			'betterdocs_single_doc_navigation_hover_color_layout_8_9' => '#344054',
			'betterdocs_single_doc_navigation_arrow_color_layout_8_9' => '#667085',
			'betterdocs_single_doc_navigation_arrow_font_size_layout_8_9' => '16',
			// 'betterdocs_post_reactions_icon_svg_color_layout_8_9' => '',
			// 'betterdocs_post_reactions_icon_hover_bg_color_layout_8_9' => '',
			// 'betterdocs_post_reactions_icon_hover_svg_color_layout_8_9' => '',
			'betterdocs_single_doc_attachment_heading_layout_8_9' => '',
			'betterdocs_doc_single_attachment_content_bg_color_layout_8_9' => 'rgba(255,255,255,0.5)',
			'betterdocs_doc_single_attachment_content_padding_layout_8_9' => '',
			'betterdocs_doc_single_attachment_content_padding_top_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_content_padding_right_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_content_padding_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_content_padding_left_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_content_margin_layout_8_9' => '',
			'betterdocs_doc_single_attachment_content_margin_top_layout_8_9' => '40',
			'betterdocs_doc_single_attachment_content_margin_right_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_content_margin_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_content_margin_left_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_label_color_layout_8_9' => '#1D2939',
			'betterdocs_doc_single_attachment_label_padding_layout_8_9' => '',
			'betterdocs_doc_single_attachment_label_padding_top_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_label_padding_right_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_label_padding_bottom_layout_8_9' => '20',
			'betterdocs_doc_single_attachment_label_padding_left_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_label_margin_layout_8_9' => '',
			'betterdocs_doc_single_attachment_label_margin_top_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_label_margin_right_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_label_margin_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_label_margin_left_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_list_font_size_layout_8_9' => '14',
			'betterdocs_doc_single_attachment_list_font_weight_layout_8_9' => '400',
			'betterdocs_doc_single_attachment_list_extension_color_layout_8_9' => '#98A2B3',
			'betterdocs_doc_single_attachment_list_extension_font_size_layout_8_9' => '14',
			'betterdocs_doc_single_attachment_list_extension_font_weight_layout_8_9' => '400',
			'betterdocs_doc_single_attachment_list_color_layout_8_9' => '#000',
			'betterdocs_doc_single_attachment_list_background_color_layout_8_9' => '#FFF',
			'betterdocs_doc_single_attachment_list_padding_layout_8_9' => '',
			'betterdocs_doc_single_attachment_list_padding_top_layout_8_9' => '12',
			'betterdocs_doc_single_attachment_list_padding_right_layout_8_9' => '12',
			'betterdocs_doc_single_attachment_list_padding_bottom_layout_8_9' => '12',
			'betterdocs_doc_single_attachment_list_padding_left_layout_8_9' => '12',
			'betterdocs_doc_single_attachment_list_margin_layout_8_9' => '',
			'betterdocs_doc_single_attachment_list_margin_top_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_list_margin_right_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_list_margin_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_attachment_list_margin_left_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_heading_layout_8_9' => '',
			'betterdocs_doc_single_related_docs_content_bg_color_layout_8_9' => 'rgba(255,255,255,0.5)',
			'betterdocs_doc_single_related_docs_content_padding_layout_8_9' => '',
			'betterdocs_doc_single_related_docs_content_padding_top_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_content_padding_right_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_content_padding_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_content_padding_left_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_content_margin_layout_8_9' => '',
			'betterdocs_doc_single_related_docs_content_margin_top_layout_8_9' => '40',
			'betterdocs_doc_single_related_docs_content_margin_right_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_content_margin_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_content_margin_left_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_label_color_layout_8_9' => '#1D2939',
			'betterdocs_doc_single_related_docs_label_padding_layout_8_9' => '',
			'betterdocs_doc_single_related_docs_label_padding_top_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_label_padding_right_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_label_padding_bottom_layout_8_9' => '20',
			'betterdocs_doc_single_related_docs_label_padding_left_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_label_margin_layout_8_9' => '',
			'betterdocs_doc_single_related_docs_label_margin_top_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_label_margin_right_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_label_margin_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_label_margin_left_layout_8_9' => '0',
			'betterdocs_doc_related_docs_list_font_size_layout_8_9' => '16',
			'betterdocs_doc_related_docs_list_font_weight_layout_8_9' => '500',
			'betterdocs_doc_single_related_docs_list_color_layout_8_9' => '#667085',
			'betterdocs_doc_single_related_docs_list_background_color_layout_8_9' => 'rgba(255,255,255,0.5)',
			'betterdocs_doc_single_related_docs_list_padding_layout_8_9' => '',
			'betterdocs_doc_single_related_docs_list_padding_top_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_list_padding_right_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_list_padding_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_list_padding_left_layout_8_9' => '18',
			'betterdocs_doc_single_related_docs_list_margin_layout_8_9' => '',
			'betterdocs_doc_single_related_docs_list_margin_top_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_list_margin_right_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_list_margin_bottom_layout_8_9' => '0',
			'betterdocs_doc_single_related_docs_list_margin_left_layout_8_9' => '0',
			'sidebar_search_layout_7'                      => '',
			'sidebar_search_field_placeholder_color_layout_7' => '#98A2B3',
			'sidebar_search_field_background_color_layout_7' => '#F9FAFB',
			'sidebar_search_field_icon_size_layout_7'      => '28',
			'modal_wrapper_section'                        => '',
			'modal_wrapper_background_color'               => '#fff',
			'modal_wrapper_padding'                        => [
				'input1' => 0,
				'input2' => 0,
				'input3' => 0,
				'input4' => 0
			],
			'modal_wrapper_margin'                         => [
				'input1' => 0,
				'input2' => 0,
				'input3' => 0,
				'input4' => 0
			],
			'search_field_modal_background_color'          => '#f9fafb',
			'search_field_modal_padding'                   => [
				'input1' => 5,
				'input2' => 5,
				'input3' => 5,
				'input4' => 5
			],
			'search_field_modal_margin'                    => [
				'input1' => 0,
				'input2' => 0,
				'input3' => 0,
				'input4' => 0
			],
			'search_field_modal_text_color'                => '#475467',
			'search_field_modal_text_font_size'            => '16',
			'search_field_modal_maginifier_icon_size'      => '28',
			'search_field_categories_text_color'           => '#667085',
			'search_field_categories_background_color'     => '#0000',
			'search_field_categories_font_size'            => '16',
			'search_modal_content_tabs_text_color'         => '#D0D5DD',
			'search_modal_content_tabs_background_color'   => '#0000',
			'search_modal_content_tabs_text_font_size'     => '14',
			'search_modal_content_tabs_margin'             => [
				'input1' => 0,
				'input2' => 0,
				'input3' => 0,
				'input4' => 0
			],
			'search_modal_content_tabs_padding'            => [
				'input1' => 0,
				'input2' => 28,
				'input3' => 0,
				'input4' => 28
			],
			'search_modal_content_tabs_border'             => [
				'input1' => 0,
				'input2' => 0,
				'input3' => 1,
				'input4' => 0
			],
			'search_modal_content_tabs_border_color'       => '#d0d5dd',
			'search_modal_content_tabs_docs_list_font_size' => '16',
			'search_modal_content_tabs_docs_list_color'    => '#1d2939',
			'search_modal_content_tabs_docs_list_background_color' => '#fff',
			'search_modal_content_tabs_docs_list_background_color_hover' => '#F6FEF9',
			'search_modal_content_tabs_docs_list_padding'  => [
				'input1' => 16,
				'input2' => 24,
				'input3' => 16,
				'input4' => 24
			],
			'search_modal_content_tabs_docs_list_margin'   => [
				'input1' => 0,
				'input2' => 0,
				'input3' => 0,
				'input4' => 0
			],
			'search_modal_content_tabs_docs_list_icon_size' => '20',
			'search_modal_content_tabs_docs_list_category_font_size' => '14',
			'search_modal_content_tabs_docs_list_category_color' => '#667085',
			'search_modal_content_tabs_docs_list_category_icon_size' => '16',
			'search_field_wrapper'                         => '',
			'search_field_categories_wrapper'              => '',
			'search_modal_content_tabs'                    => '',
			'search_modal_content_tabs_docs_list'          => '',
			'betterdocs_search_layout_select'              => 'layout-2',
			'betterdocs_faq_category_title_color_layout_3' => '#15063f',
			'betterdocs_faq_category_name_font_size_layout_3' => '25',
			'betterdocs_faq_category_name_padding_layout_3' => [
				'input1' => 20,
				'input2' => 20,
				'input3' => 20,
				'input4' => 20
			],
			'betterdocs_faq_list_color_layout_3'           => '#172b4d',
			'betterdocs_faq_list_background_color_layout_3' => 'rgba(255,255,255,0.5)',
			'betterdocs_faq_list_content_background_color_layout_3' => '#0000',
			'betterdocs_faq_list_content_color_layout_3'   => '#3a4b68',
			'betterdocs_faq_list_content_font_size_layout_3' => '16',
			'betterdocs_faq_list_font_size_layout_3'       => '18',
			'betterdocs_faq_list_padding_layout_3'         => [
				'input1' => 24,
				'input2' => 14,
				'input3' => 24,
				'input4' => 14
			],
			'betterdocs_single_doc_breadcrumbs_font_size_layout_8_9' => '12',
			'betterdocs_single_doc_breadcrumb_color_layout_8_9' => '#667085',
			'betterdocs_single_doc_breadcrumb_hover_color_layout_8_9' => '#667085',
			'betterdocs_single_doc_breadcrumb_speretor_color_layout_8_9' => '#667085',
			'betterdocs_single_doc_breadcrumb_active_item_color_layout_8_9' => '#344054',
			'betterdocs_single_doc_breadcrumb_background_color_layout_8_9' => '#F9FAFB',
			'search_modal_query_section'                   => '',
			'search_modal_query_initial_number_of_docs'    => 5,
			'search_modal_query_initial_number_of_faqs'    => 5,
			// 'search_modal_query_select_specific_faq'                        => '',
			// 'search_modal_query_select_specific_doc_category'               => '',
			'category_title_margin_layout_7'               => '',
			'category_title_margin_top_layout_7'           => '0',
			'category_title_margin_right_layout_7'         => '0',
			'category_title_margin_bottom_layout_7'        => '16',
			'category_title_margin_left_layout_7'          => '0',
			'doc_page_item_count_margin_layout_7'          => '',
			'doc_page_item_count_margin_top_layout_7'      => '0',
			'doc_page_item_count_margin_right_layout_7'    => '0',
			'doc_page_item_count_margin_bottom_layout_7'   => '6',
			'doc_page_item_count_margin_left_layout_7'     => '0',
			'content_area_padding_layout_7'                => '',
			'content_area_padding_top_layout_7'            => '58',
			'content_area_padding_right_layout_7'          => '56',
			'content_area_padding_bottom_layout_7'         => '56',
			'content_area_padding_left_layout_7'           => '56',
			'archive_category_margin_layout_7'             => '',
			'archive_category_margin_top_layout_7'         => '0',
			'archive_category_margin_right_layout_7'       => '0',
			'archive_category_margin_bottom_layout_7'      => '16',
			'archive_category_margin_left_layout_7'        => '0',
			'archive_search_wrapper'                       => '',
			'archive_search_toogle'                        => false,
			'archive_search_width'                         => '100',
			'archive_search_max_width'                     => '1400',
			'archive_search_margin'                        => '',
			'archive_search_margin_top'                    => '0',
			// 'archive_search_margin_right'                                   => '0',
			'archive_search_margin_bottom'                 => '0',
			// 'archive_search_margin_left'                                    => '0',
			'archive_search_padding'                       => '',
			'archive_search_padding_top'                   => '0',
			'archive_search_padding_right'                 => '25',
			'archive_search_padding_bottom'                => '0',
			'archive_search_padding_left'                  => '25',
			'single_doc_layout_8_9_search_wrapper'         => '',
			'single_doc_layout_8_9_search_toogle'          => false,
			'single_doc_layout_8_9_search_width'           => '100',
			'single_doc_layout_8_9_search_max_width'       => '1400',
			'single_doc_layout_8_9_search_margin'          => '',
			'single_doc_layout_8_9_search_margin_top'      => '0',
			'single_doc_layout_8_9_search_margin_bottom'   => '0',
			'single_doc_layout_8_9_search_padding'         => '',
			'single_doc_layout_8_9_search_padding_top'     => '0',
			'single_doc_layout_8_9_search_padding_right'   => '25',
			'single_doc_layout_8_9_search_padding_bottom'  => '0',
			'single_doc_layout_8_9_search_padding_left'    => '25',
			'archive_docs_list_title_margin_layout_7'      => '',
			'archive_docs_list_title_margin_top_layout_7'  => '0',
			'archive_docs_list_title_margin_right_layout_7' => '0',
			'archive_docs_list_title_margin_bottom_layout_7' => '0',
			'archive_docs_list_title_margin_left_layout_7' => '0',
			'archive_page_item_count_margin_layout_7'      => '',
			'archive_page_item_count_margin_top_layout_7'  => '0',
			'archive_page_item_count_margin_right_layout_7' => '0',
			'archive_page_item_count_margin_bottom_layout_7' => '6',
			'archive_page_item_count_margin_left_layout_7' => '0',
			'archive_last_updated_time_layout_7_margin'    => '',
			'archive_last_updated_time_layout_7_margin_top' => '0',
			'archive_last_updated_time_layout_7_margin_right' => '0',
			'archive_last_updated_time_layout_7_margin_bottom' => '0',
			'archive_last_updated_time_layout_7_margin_left' => '0',
			'archive_last_updated_time_layout_7_padding'   => '',
			'archive_last_updated_time_layout_7_padding_top' => '8',
			'archive_last_updated_time_layout_7_padding_right' => '8',
			'archive_last_updated_time_layout_7_padding_bottom' => '8',
			'archive_last_updated_time_layout_7_padding_left' => '8',
			'archive_docs_list_excerpt_margin_layout_7'    => '',
			'archive_docs_list_excerpt_margin_top_layout_7' => '0',
			'archive_docs_list_excerpt_margin_right_layout_7' => '0',
			'archive_docs_list_excerpt_margin_bottom_layout_7' => '0',
			'archive_docs_list_excerpt_margin_left_layout_7' => '0',
			'single_doc_title_margin_layout_8_9'           => '',
			'single_doc_title_margin_top_layout_8_9'       => '0',
			'single_doc_title_margin_right_layout_8_9'     => '0',
			'single_doc_title_margin_bottom_layout_8_9'    => '0',
			'single_doc_title_margin_left_layout_8_9'      => '0',
			'toc_title_margin_layout_8_9'                  => '',
			'toc_title_margin_top_layout_8_9'              => '0',
			'toc_title_margin_right_layout_8_9'            => '0',
			'toc_title_margin_bottom_layout_8_9'           => '0',
			'toc_title_margin_left_layout_8_9'             => '0',
			'single_content_padding_layout_8_9'            => '',
			'single_content_padding_top_layout_8_9'        => '0',
			'single_content_padding_right_layout_8_9'      => '0',
			'single_content_padding_bottom_layout_8_9'     => '0',
			'single_content_padding_left_layout_8_9'       => '0',
			'single_content_margin_layout_8_9'             => '',
			'single_content_margin_top_layout_8_9'         => '0',
			'single_content_margin_right_layout_8_9'       => '0',
			'single_content_margin_bottom_layout_8_9'      => '0',
			'single_content_margin_left_layout_8_9'        => '0',
			'post_reactions_margin_layout_8'               => '',
			'post_reactions_margin_top_layout_8'           => '0',
			'post_reactions_margin_right_layout_8'         => '0',
			'post_reactions_margin_bottom_layout_8'        => '0',
			'post_reactions_margin_left_layout_8'          => '0',
			'post_reactions_padding_layout_8'              => '',
			'post_reactions_padding_top_layout_8'          => '40',
			'post_reactions_padding_right_layout_8'        => '40',
			'post_reactions_padding_bottom_layout_8'       => '40',
			'post_reactions_padding_left_layout_8'         => '40',
			'post_reactions_border_layout_8'               => '',
			'post_reactions_border_top_layout_8'           => '1',
			'post_reactions_border_right_layout_8'         => '1',
			'post_reactions_border_bottom_layout_8'        => '1',
			'post_reactions_border_left_layout_8'          => '1',
			'post_social_share_margin_layout_8'            => '',
			'post_social_share_margin_top_layout_8'        => '0',
			'post_social_share_margin_right_layout_8'      => '0',
			'post_social_share_margin_bottom_layout_8'     => '0',
			'post_social_share_margin_left_layout_8'       => '0',
			'post_social_share_padding_layout_8'           => '',
			'post_social_share_padding_top_layout_8'       => '40',
			'post_social_share_padding_right_layout_8'     => '24',
			'post_social_share_padding_bottom_layout_8'    => '40',
			'post_social_share_padding_left_layout_8'      => '24',
			'betterdocs_single_doc_lu_time_color_layout_8_9' => '#475467',
			'single_doc_lu_time_font_size_8_9'             => '14',
			'post_reactions_margin_layout_9'               => '',
			'post_reactions_margin_top_layout_9'           => '24',
			'post_reactions_margin_right_layout_9'         => '0',
			'post_reactions_margin_bottom_layout_9'        => '0',
			'post_reactions_margin_left_layout_9'          => '0',
			'post_reactions_padding_layout_9'              => '',
			'post_reactions_padding_top_layout_9'          => '32',
			'post_reactions_padding_right_layout_9'        => '24',
			'post_reactions_padding_bottom_layout_9'       => '32',
			'post_reactions_padding_left_layout_9'         => '24',
			'post_social_share_margin_layout_9'            => '',
			'post_social_share_margin_top_layout_9'        => '40',
			'post_social_share_margin_right_layout_9'      => '0',
			'post_social_share_margin_bottom_layout_9'     => '0',
			'post_social_share_margin_left_layout_9'       => '0',
			'post_social_share_padding_layout_9'           => '',
			'post_social_share_padding_top_layout_9'       => '32',
			'post_social_share_padding_right_layout_9'     => '24',
			'post_social_share_padding_bottom_layout_9'    => '32',
			'post_social_share_padding_left_layout_9'      => '24',
			'sidebar_search_layout_7_toggle'               => true,
			'sidebar_search_field_margin_layout_7'         => '',
			'sidebar_search_field_margin_top_layout_7'     => '0',
			'sidebar_search_field_margin_right_layout_7'   => '0',
			'sidebar_search_field_margin_bottom_layout_7'  => '0',
			'sidebar_search_field_margin_left_layout_7'    => '0',
			'sidebar_search_field_padding_layout_7'        => '',
			'sidebar_search_field_padding_top_layout_7'    => '8',
			'sidebar_search_field_padding_right_layout_7'  => '10',
			'sidebar_search_field_padding_bottom_layout_7' => '8',
			'sidebar_search_field_padding_left_layout_7'   => '10',
			'sidebar_search_field_command_key_padding_layout_7' => '',
			'sidebar_search_field_command_key_padding_top_layout_7' => '0',
			'sidebar_search_field_command_key_padding_right_layout_7' => '0',
			'sidebar_search_field_command_key_padding_bottom_layout_7' => '0',
			'sidebar_search_field_command_key_padding_left_layout_7' => '0',
			'sidebar_search_field_command_key_color_layout_7' => '#667085',
			'item_count_font_padding_layout_7'             => '',
			'item_count_font_padding_top_layout_7'         => '0',
			'item_count_font_padding_right_layout_7'       => '0',
			'item_count_font_padding_bottom_layout_7'      => '0',
			'item_count_font_padding_left_layout_7'        => '0',
			'betterdocs_sidebar_list_item_padding_layout_7' => '',
			'betterdocs_sidebar_list_item_padding_top_layout_7' => '0',
			'betterdocs_sidebar_list_item_padding_right_layout_7' => '0',
			'betterdocs_sidebar_list_item_padding_bottom_layout_7' => '0',
			'betterdocs_sidebar_list_item_padding_left_layout_7' => '0',
			'betterdocs_sidebar_list_item_active_color_layout_7' => '#a1dcc0',
			'toc_active_item_border_color_layout_8_9'      => '#A1DCC0',
			'search_modal_query_doc_ids'                   => '',
			'search_modal_query_doc_term_ids'              => '',
			'search_modal_query_type'                      => 'popular_docs',
			'search_modal_faq_query_type'                  => 'default',
			'search_modal_query_faq_term_ids'              => '',
			'archive_docs_pagination'                      => '',
			'archive_docs_pagination_wrapper_height'       => '40',
			'archive_docs_pagination_wrapper_width'        => '40',
			'archive_docs_pagination_wrapper_font_size'    => '14',
			'archive_docs_pagination_wrapper_color'        => '#737a85',
			'archive_docs_pagination_wrapper_active_color' => '#00b884',
			'archive_docs_pagination_wrapper_active_border_color' => '#00b884',
			'archive_docs_pagination_wrapper_background_color_sleek' => '#f6f7f8',
			'archive_docs_pagination_wrapper_background_color' => '#fff',
		];

		if ( ! empty( $key ) ) {
			return isset( $betterdocs_defaults[ $key ] ) ? $betterdocs_defaults[ $key ] : '';
		}

		return apply_filters( 'betterdocs_option_defaults', $betterdocs_defaults );
	}

	public function get( $key, $default = '' ) {
		if ( empty( $key ) ) {
			throw new \InvalidArgumentException( '#1 args needed as string.' );
		}

		if ( empty( $default ) ) {
			$default = $this->defaults( $key );
		}

		// $_options = wp_parse_args( $this->generate_defaults(), $this->defaults() );
		// return isset( $_options[$key] ) ? $_options[$key] : $default;

		return get_theme_mod( $key, $default );
	}

	public function generate_defaults() {
		$_return_values = [];
		foreach ( $this->defaults() as $key => $default ) {
			$_return_values[ $key ] = get_theme_mod( $key, $default );
		}

		return $_return_values;
	}

	public function theme_mods() {
		$values = wp_cache_get( 'betterdocs-theme-mods', 'betterdocs', true ); // getting the mods values from cache

		if ( false !== $values ) {
			return $values;
		}

		$default_options = $this->defaults();
		$values          = [];
		foreach ( $default_options as $key => $default ) {
			$values[ $key ] = get_theme_mod( $key, $default );
		}

		wp_cache_set( 'betterdocs-theme-mods', $values, 'betterdocs' ); // set the value in cache.
		return $values;
	}
}
